#include <cstdint>
#include <iostream>
#include <sstream>
#include <utility>
#include <vector>

 std::vector<uint64_t>int_arr_input(const uint64_t len) {
  std::string input;
  std::getline(std::cin, input, '\n');
  auto out = std::vector<uint64_t>(len);
  std::istringstream iss(input);
  for (int i = 0; i < len; i++) {
    iss >> out[i];
  }
  return out;
}

void sort(std::vector<uint64_t> arr) {
  bool swapped = false;
  for (uint64_t passes = 0; passes < arr.size(); passes++) {
    for (uint64_t i = 0; i < arr.size() - passes - 1; i++) {
      if (arr[i] > arr[i+1]) {
        std::swap(arr[i], arr[i+1]);
      }
    }
    if (!swapped) { return; }
  }
}

std::vector<uint64_t> sort_rm_duplicates(std::vector<uint64_t> arr, std::vector<uint64_t>& duplicatesOut) {
  std::vector<uint64_t> out;
  sort(arr);

  uint64_t prevVal = 0;
  for (int i = 0; i < arr.size(); i++) {
    if (i != 0 && prevVal == arr[i]) {
      duplicatesOut.push_back(arr[i]);
      continue;
    }
    out.push_back(arr[i]);
  }
  return out;
}

uint64_t doXor(uint64_t val1, uint64_t val2) {
  return val1 ^ val2;
}
uint64_t doAnd(uint64_t val1, uint64_t val2) {
  return val1 & val2;
}

uint64_t find_max(std::vector<uint64_t> arr, uint64_t (*exec)(uint64_t a, uint64_t b)) {
  uint64_t maxVal = 0;
  uint64_t val = 0;
  for (uint64_t passes = 0; passes < arr.size(); passes++) {
    for (uint64_t i = 0; i < arr.size() - 1; i++) {
      if (passes == i) { continue; }
      val = exec(arr[i], arr[i+1]);
      if (val > maxVal) {
        maxVal = val;
      }
    }
  }
  return maxVal;
}

int main() {
  uint64_t arrLen;
  std::cin >> arrLen;
  std::cin.ignore(); // C++, I h8 u
  auto arr1 = int_arr_input(arrLen);
  std::cin.ignore(); // But I still h8 py more
  auto arr2 = int_arr_input(arrLen);

  std::vector<uint64_t> duplicates1;
  std::vector<uint64_t> duplicates2;
  auto maxValXor = find_max(sort_rm_duplicates(arr1, duplicates1), doXor);
  auto maxValAnd = find_max(sort_rm_duplicates(arr2, duplicates2), doAnd);

  // Check duplicates
  for (uint32_t i = 0; i < duplicates1.size(); i++) {
    uint64_t val = 0;
    val = duplicates1[i] ^ duplicates1[i]; 
    if (val > maxValXor) {
      maxValXor = val;
    }
  }
  for (uint32_t i = 0; i < duplicates2.size(); i++) {
    uint64_t val = 0;
    val = duplicates2[i] & duplicates2[i]; 
    if (val > maxValAnd) {
      maxValAnd = val;
    }
  }

  std::cout << maxValXor * maxValAnd << '\n';
  return 0;
}